<?php

declare(strict_types=1);

namespace NeuronAI\Tools;

use JsonSerializable;

interface ToolInterface extends JsonSerializable
{
    /**
     * Get the unique name of the tool.
     */
    public function getName(): string;

    public function setName(string $name): ToolInterface;

    /**
     * Get a description of the tool's functionality.
     */
    public function getDescription(): ?string;

    public function setDescription(?string $description): ToolInterface;

    /**
     * Add a Property with a name, type, description, and optional required constraint.
     */
    public function addProperty(ToolPropertyInterface $property): ToolInterface;

    /**
     * Get the Properties schema.
     */
    public function getProperties(): array;

    /**
     * Get the annotations present on the tool.
     * @return array<string, mixed>
     */
    public function getAnnotations(): array;

    /**
     * Names of the required properties.
     *
     * @return array<string>
     */
    public function getRequiredProperties(): array;

    /**
     * Define the code to be executed.
     */
    public function setCallable(callable $callback): ToolInterface;

    /**
     * Get the input arguments of the function call.
     */
    public function getInputs(): array;

    /**
     * Get the input arguments of the function call.
     */
    public function setInputs(array $inputs): ToolInterface;

    /**
     * The call identifier generated by the LLM.
     */
    public function getCallId(): ?string;


    public function setCallId(string $callId): ToolInterface;


    public function getResult(): string;

    /**
     * Define the maximum number of calls for the tool in a single agent session.
     */
    public function getMaxTries(): ?int;

    public function setMaxTries(int $tries): ToolInterface;

    /**
     * Execute the tool's logic with input parameters.
     */
    public function execute(): void;
}
