# Dispatcher

A mailing plugin for WordPress to send emails to site users.

## Install

Read the short instruction on the [official page](https://www.satollo.net/plugins/dispatcher).

## Performances

Since it uses almost only features of WP, it should be extra light. No fancy styles,
database tables, complex framework. Only old plain code.

But be aware: the sending performances depend on your hosting provider (or the delivery service
you connected your site to - see below): don't blame the plugin if it takes 24 hours to send
the messasges to your 2400 users if your max sending speed is 100 emails per hours!

## Testing

You can configure it to redirect all the email to a single address, again for test
purposes.

## What's inside

The sending engine runs every 15 minutes, process 25 users per run **but if at least three of you
ask me to customize the speed**, I'll do it.

The plugin logs every operation when the WP_DEBUG constant is set to true, and it logs directly on
the wp-content/debug.log file.

Emails are edited using the classic editor. I'll add an option to activate Gutenberg, but then the
content won't show correctly on many email clients (or probably none).

Users can be targeted by role. If you need to define other roles than the ones provided by WP
consider installing [User Role Manager](https://wordpress.org/plugins/user-role-editor/) or
[Members](https://wordpress.org/plugins/members/).

It is mainly used to
test the [Assistant](https://github.com/stefanolissa/assistant) plugin and register a number
of abilities that can be used by chatting with the assistant.

### Email queuing

Since you don't want send 1000 emails in a few seconds (the hosting provider will ban you for sure)
the plugin has a built-in sending engine that "smoothly" send all emails with a configured speed.

Of course, math is not an opinion: if the speed is 100 emails per hours and you have 2400 users, the sending
process will take 24 hours!

If your business requires sending a big quantity of emails in a very short time, you have a few options:

- pay and use a professional email marketing service, almost always they have a plugin to synch the WP users
with their subscriber database and move the process out of WP

- get a professional delivery service and connect it with your site using an SMTP plugin or a dedicated plugin,
if they provide one: then you can raise the sending speed to the limits of your plan

- belive you can send at your preferred speed and try: you probably will see all the emails sent, even logged
by [WP Mail Logging](https://wordpress.org/plugins/wp-mail-logging/) but probably no one is receiving them (hint:
hosting provider silently drop them, [read here](https://www.satollo.net/how-email-delivery-works-in-wordpress-and-why-it-can-fail)).

### Email sending

Emails are sent using WP, so if they're not delivered **it is not a problem of this plugin**.

Install [WP Mail Logging](https://wordpress.org/plugins/wp-mail-logging/) to see al the emails sent
and if there are errors.

If there are errors, please contact your hosting provider.

Why an email can fail when sent by WP is [clearly explained here](https://www.satollo.net/how-email-delivery-works-in-wordpress-and-why-it-can-fail).

I suggest using an SMTP plugin so all emails generated by your site are delivered via that service. It is
much more reliable. Ask the hosting provider the SMTP parameters.

### The scheduler

To send the emails the WP scheduler MUST work correctly. Many time it doesn't because of low site
traffic, caching, an tons of other problems. That affect not only this plugin but the whole site.
Install [WP Crontrol](https://wordpress.org/plugins/wp-crontrol/) for a detailed view on the scheduler,
jobs, and possible issues. Possible ask the provider to trigger the wp-cron.php of your site every
15 minutes (using php or curl or wget).

Another diagnostic tool is my [Monitor plugin](https://www.satollo.net/plugins/monitor) but it requires a
tech-aware person to be interpreted.

If your hosting provider is not able to setup that trigger or refuse to do it, change the hosting provider
asap. An alternative is to sign up at [Cron Jobs](https://cron-job.org/en/) and set the trigger
yourself. You can find the URL to add to configiure the Cron Jobs service on this plugin main settings.

### Debugging

If you want help me debug issues you face, please activate the `WP_DEBUG` and share with me what's written
in the debug.log file.

If you **don't know** what `WP_DEBUG`, `WP_DEBUG_LOG`, `WP_DEBUG_DISPLAY` are
please **avoid to mess up** your wp-config.php file, we'll find another way to solve the issue.

### How To and FAQ

No, this plugin is not meant to be a full featured email editor, there are other solution (free and paid) available.
Use it if you simple need to send great content to your users, not great layouts (I understand the importance
of great layouts, as said there are many alternatives available, just search form them).

If you need to duplicate and email, use the [Yoast Duplicate Post](https://wordpress.org/plugins/duplicate-post/)
plugin or one of the many other available.

If you want/don't want the content of the email be available to the public, publish it
or keep it as draft.

You can use shortcodes in the email content, they're rendered before sending the message. Of course, they
can produce HTML not correctly rendered on email readers. They can even produce JavaScript that could raise the
spam score (I should add a filter...).

Emails cannot be sceduled to be sent in the future. The future publishing is not related to the sending process
at the moment but only to the (possible) visibility on the site.

Email online visibility can be protected/limited using the standard WP "Password Protected" option or any
valid membership plugin. Examples: [Ultimate Member](https://wordpress.org/plugins/ultimate-member/),
[Members](https://wordpress.org/plugins/members/), [Paid Membership Pro](https://www.paidmembershipspro.com/), ...

Membership plugins, 99% of the times, create WP roles corresponding to the membershiop levels, so you can
easily send emails to specific users out of the box.

Images are not showed correctly on email clients. Yes, it's a common pitfall of (some) email readers. Try to force
a size, like 600 pixels.

If you have one or more sending emails, the engine will process the older one untile it finishes and the
move to the next one.

When you press the test button to send a test email, it is sent to the current user email address (yes, yes, YES,
I'll change that).

Conditional rules on email's content, based on user profile, role, level, and so on **cannot be used** since the
email is rendered once and sent to all users. Festures will be added in the future (vote for them!)
to improve the personalisation at levels you cannot imagine!

No, the text part is not supported, only the HTML content is sent. No, pure text emails are not supported.

The "email snippet" that short text anticipating the content you can see on GMail and some other email reader can be
set using the "excerpt". Be short, only a few words are shown. The text is added on top of the email message and
styled to be invisible. Yes, it's ok doing that.

Artificial intelligence. There are an explosion of plugins that bring to WP AI features,
just try a couple of them. Since emails are edited with the standard WP editor... they should work.

If you want use both Gutenberg and the classic editor, install the [Classic Editor](https://wordpress.org/plugins/classic-editor/)
plugin so you can switch when nedded.

The online version of the email is shows as a regular post, inside your theme. The adapted rendering for email clients is
done only while sending. So what you see on an email client is not what you see on the online version (which is much better!).

## To Do

- Add the BCC sending mode
- Add messages personalization
- Adjust images on the content to be more compatible with silly email readers (Outlook to name one)
- Tracking? I don't think...
- Unsubscribe option? I don't think... I should define a role or a user meta value.
- Templates? Uhm... why not just duplicating the latest email?
- Remove the "redirect emails" setting? I already know someone will misuse it claiming the plugin is not working...
- Add the delete all emails on unistall? Nah, they can be easily deleted from the admin side before unistalling.
- More complex autdience settings? For example "exclude roles" option?
- Add general settings to ALWAYS exclude some roles to be targeted? For example a role used as unsubscribed indicator or a general block?
- Add a stressful assistant remebering you to send an email from time to time to your users?
- Add future sending option?
- Add option to have the emails public content or not.
- Placeholders/merge tags for user data?
- Translations? I don't think it will be diffused enough to justify the effort...

## Disclaimer

This is very naif code just to play with abilities it is not meant to become a production
plugin. Use it on a test environment.

## The Assistant

The [Assistant](https://github.com/stefanolissa/assistant) plugin is a chatbot using an AI provider of
your choice and the WordPress abilities to execute the requested tasks.

For example you can ask "show the stats of the last email" or "compare the stats of the last two emails".



