<?php

defined('ABSPATH') || exit;

add_filter('update_plugins_satollo-simplesmtp', function ($update, $plugin_data, $plugin_file, $locales) {
    $slug = 'simplesmtp';
    $data = get_option($slug . '_update_data');
    if ($data && $data->updated < time() - WEEK_IN_SECONDS || isset($_GET['force-check'])) {
        $data = false;
    }

    if (!$data) {
        $response = wp_remote_get('https://www.satollo.net/repo/' . $slug . '/plugin.json');
        $data = json_decode(wp_remote_retrieve_body($response));
        if (is_object($data)) {
            $data->updated = time();
            update_option($slug . '_update_data', $data, false);
        }
    }

    if (isset($data->version)) {

        $update = [
            'version' => $data->version,
            'slug' => $slug,
            'url' => 'https://www.satollo.net/plugins/' . $slug,
            'package' => 'https://www.satollo.net/repo/' . $slug . '/' . $slug . '.zip'
        ];
        return $update;
    } else {
        return false;
    }
}, 0, 4);

function simplesmtp_render_markdown($text) {
    $text = preg_replace('/^### (.*$)/m', '<h4>$1</h4>', $text);
    $text = preg_replace('/^## (.*$)/m', '<h3>$1</h3>', $text);
    $text = preg_replace('/^# (.*$)/m', '', $text);
    $text = preg_replace('/^- (.*$)/m', '- $1<br>', $text);
    $text = preg_replace('/\*\*(.*?)\*\*/m', '<strong>$1</strong>', $text);
    $text = preg_replace('/`(.*?)`/m', '<code>$1</code>', $text);
    $text = preg_replace('/\[([^\]]+)\]\(([^)]+)\)/', '<a href="$2" target="_blank">$1</a>', $text);
    $text = wpautop($text, false);
    $text = wp_kses_post($text);
    return $text;
}

add_filter('plugins_api', function ($res, $action, $args) {
    $slug = 'simplesmtp';
    if ($action !== 'plugin_information' || $args->slug !== '$slug') {
        return $res;
    }

    $response = wp_remote_get('https://www.satollo.net/repo/' . $slug . '/CHANGELOG.md');
    $changelog = '';
    if (wp_remote_retrieve_response_code($response) == '200') {
        $changelog = wp_remote_retrieve_body($response);
        $changelog = simplesmtp_render_markdown($changelog);
    }

    $response = wp_remote_get('https://www.satollo.net/repo/' . $slug . '/README.md');
    $readme = '';
    if (wp_remote_retrieve_response_code($response) == '200') {
        $readme = wp_remote_retrieve_body($response);
        $readme = simplesmtp_render_markdown($readme);
    }

    $res = new stdClass();
    $res->name = 'SimpleSMTP';
    $res->slug = $slug;
    $res->version = SIMPLESMTP_VERSION;
    $res->author = '<a href="https://www.satollo.net">Stefano Lissa</a>';
    $res->homepage = 'https://www.satollo.net/plugins/' . $slug;
    $res->download_link = 'https://www.satollo.net/repo/' . $slug . '/' . $slug . '.zip';

    $res->sections = [
        'description' => $readme,
        'changelog' => $changelog,
    ];

    $res->banners = [
        'low' => 'https://www.satollo.net/repo/' . $slug . '/banner.png',
        'high' => 'https://www.satollo.net/repo/' . $slug . '/banner.png'
    ];

    $res->icons = [
        '1x' => 'https://www.satollo.net/repo/' . $slug . '/icon.png',
        '2x' => 'https://www.satollo.net/repo/' . $slug . '/icon.png'
    ];

    return $res;
}, 20, 3);
